# ifndef _ADT8960m_H__ 
# define _ADT8960m_H__ 

long _stdcall adt8960_initial (void); 
/*************************** Initialize the card ****************** ************ 
Function: Initialize motion control card 
(1) return value> 0, the number of cards that adt8960. If 3, then the following card numbers can be 0,1,2, respectively; 
(2) return value = 0, that is not installed adt8960 card; 
(3) return value <0, -1 port drivers not installed, -2, said PCI bridge failure. 
************************************************** ***************/ 

int _stdcall adt8960_set_pulse_mode (int cardno, int axis, int value, int logic, int dir_logic); 
/******************** Set the output pulse of the work *********************** 
Features: 
Work to set the output pulse 
Parameters: 
cardno card number 
axis axis number (1-6) 
value 0: Pulse + Pulse Mode 1: Pulse + direction method 
logic 0: positive logic pulse 1: Negative logic pulse 
dir-logic 0: the direction of the output signal is logic 1: negative logic output signal of the direction of 
Return Value 0: Correct 1: Error 
The default mode is: Pulse + direction method, positive logic pulse and direction output signal is logic 
************************************************** ***************/ 

int _stdcall adt8960_set_limit_mode (int cardno, int axis, int v1, int v2, int logic); 
/************* Set positive / negative direction limit input signal mode settings nLMT ************* 
Features: 
Set the positive / negative direction limit input signal mode nLMT 
Parameters: 
cardno card number 
axis axis number (1-6) 
v1 0: 1 is the effective limit: Limit is invalid 
v2 0: negative limit effective 1: Negative limit is invalid 
logic 0: active low 1: active high 
Return Value 0: Correct 1: Error 
The default mode is: is the effective limit the negative limit, active-low 
Note: The signal can not be set to limit valid / invalid. 
************************************************** ***************/ 

int _stdcall adt8960_set_stop0_mode (int cardno, int axis, int v, int logic); 
/******************** Set the input mode ********************** stop0 
Function: Setting stop0 signal valid / invalid and logic level 
Parameters: 
cardno card number 
axis axis number (1-6) 
v 0: Invalid 1: Valid 
logic 0: Low Stop 1: Stop high 
Return Value 0: Correct 1: Error 
The default mode is:: invalid, low stop 
************************************************** ***************/ 

int _stdcall adt8960_set_stop1_mode (int cardno, int axis, int v, int logic); 
/********************* Set the input mode ********************* stop1 
Function: Setting stop1 signal valid / invalid and logic level 
Parameters: 
cardno card number 
axis axis number (1-6) 
v 0: Invalid 1: Valid 
logic 0: Low Stop 1: Stop high 
Return Value 0: Correct 1: Error 
The default mode is:: invalid, low stop 
************************************************** ***************/ 

//------------------------------------------------ ----// 
// Driver status check function // 
//------------------------------------------------ ----// 
int _stdcall adt8960_get_status (int cardno, int axis, int * v); 
/************************* For each axis drive state ****************** **** 
Features: 
Get the driving state of uniaxial 
Parameters: 
cardno card number 
axis axis number (1-6) 
v pointer to drive the state 
0: Drive end of the non-0: value for the two-byte length value 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 
int _stdcall adt8960_get_inp_status (int cardno, int * v); 
/************************ For interpolation driving status ******************* **** 
Features: 
Get the driving state of motion interpolation 
Parameters: 
cardno card number 
v interpolation state pointer 
0: interpolation end of the 1: is interpolation 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

//------------------------------------------------ ----// 
// Set the function of motion parameters // 
//------------------------------------------------ ----// 
int _stdcall adt8960_set_acc (int cardno, int axis, long add); 
/************************** Acceleration setting ******************** ********* 
Features: 
Set the value of acceleration 
Parameters: 
cardno card number 
axis axis number (1-6) 
add (1-64000) 
Hardware Acceleration = add/125 version 1 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_set_startv (int cardno, int axis, long speed); 
/************************* Set the initial velocity ******************* ********* 
Features: 
Initial speed setting 
Parameters: 
cardno card number 
axis axis number (1-6) 
speed range (1-2M) 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_set_speed (int cardno, int axis, long speed); 
/*************************** Set the drive speed ****************** ******** 
Features: 
Drive speed setting 
Parameters: 
cardno card number 
axis axis number (1-6) 
speed range (1-2M) 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_set_command_pos (int cardno, int axis, long pos); 
/************************* Set the logical location ******************** ******** 
Features: 
Logic position setting 
Parameters: 
cardno card number 
axis axis number (1-6) 
pos range (-2147483648 ~ +2147483647) 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_set_actual_pos (int cardno, int axis, long pos); 
/************************** Set the actual position ******************* ******** 
Features: 
Set the actual location 
Parameters: 
cardno card number 
axis axis number (1-6) 
pos range (-2147483648 ~ +2147483647) 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_set_symmetry_speed (int cardno, int axis, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************** Set acceleration ******************** **** 
Function: Set the value of acceleration 
Parameters: 
cardno card number 
axis axis number (1-6) 
lspd initial velocity 
    hspd drive speed 
tacc acceleration time 
acceleration mode mode (0: trapezoidal, 1: S-type) 
vacc acceleration rate of change 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Check the function of motion parameters // 
//------------------------------------------------ ----// 
int _stdcall adt8960_get_command_pos (int cardno, int axis, long * pos); 
/************************** For logical location ******************** ******** 
Features: 
Logical location for each axis 
Parameters: 
cardno card number 
axis axis number (1-6) 
logical location of the cursor pos 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_get_actual_pos (int cardno, int axis, long * pos); 
/************************* Obtain the actual location ********************* ******* 
Features: 
Get the actual position of each axis 
Parameters: 
cardno card number 
axis axis number (1-6) 
pos a pointer to the actual location 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_get_speed (int cardno, int axis, long * speed); 
 /************************** ******* Get drive speed ********************
Features: 
Get current driving speed for each axis 
Parameters: 
cardno card number 
axis axis number (1-6) 
pointer to the current driving speed speed 
Return Value 0: Correct 1: Error 
************************************************** ***************/ 

int _stdcall adt8960_get_out (int cardno, int number); 
/*************************** For output state ******************* ******** 
Function: Get output status 
Parameters: 
cardno card number 
port number 
Returns: the current state of specified port, -1 means the parameter error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Driver function // 
//------------------------------------------------ ----// 
int _stdcall adt8960_pmove (int cardno, int axis, long pos); 
/************************* Quantitatively driven ********************** ***** 
Features: 
Quantitative single-axis drive 
Parameters: 
cardno card number 
axis axis number (1-6) 
pulse output pulse range (-268 435 455 ~ +268435455) 
> 0: positive direction <0: Negative direction 
Return Value 0: Correct 1: Error 
************************************************** ************/ 


int _stdcall adt8960_continue_move (int cardno, int axis, int dir); 
/************************* Continuous drive ********************** ***** 
Features: 
Uniaxial continuous drive 
Parameters: 
cardno card number 
axis axis number (1-6) 
driven in the direction dir 
0: positive direction 1: Negative direction 
Return Value 0: Correct 1: Error 
************************************************** *************/ 

int _stdcall adt8960_dec_stop (int cardno, int axis); 
/************************** Driver deceleration stop ******************** ***** 
Features: 
Driven process to stop the current slowdown 
Parameters: 
cardno card number 
axis axis number (1-6) 
Return Value 0: Correct 1: Error 
************************************************** *************/ 

int _stdcall adt8960_sudden_stop (int cardno, int axis); 
/*************************** Driver to immediately stop ******************* ***** 
Features: 
Immediately stop the current-driven process 
Parameters: 
cardno card number 
axis axis number (1-6) 
Return Value 0: Correct 1: Error 
Immediately stop the pulse output is being driven, in the acceleration / deceleration drive also stop immediately. 
************************************************** ****************/ 

int _stdcall adt8960_inp_move2 (int cardno, int axis1, int axis2, long pulse1, long pulse2); 
/**************************** Two-axis linear interpolation **************** ********* 
Features: 
Two-axis linear interpolation motion 
Parameters: 
cardno card number 
axis1, axis2 axis number in interpolation 
pulse1, pulse2 move relative distance range (-8388608 ~ +8388607) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_inp_move3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3); 
/***************************** Axis linear interpolation *************** *********** 
Features: 
Three-axis linear interpolation movement 
Parameters: 
cardno card number 
axis1, axis2.axis3 number in the axis interpolation 
pulse1, pulse2, pulse3 move relative distance range (-8388608 ~ +8388607) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_inp_move4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4); 
/*********************** Features: Four-axis linear interpolation ******************* ***** 
Features: 
Four-axis linear interpolation movement 
Parameters: 
cardno card number 
axis1, axis2.axis3, axis4 number in the axis interpolation 
pulse1, pulse2, pulse3, pulse4 move relative distance range (-8388608 ~ +8388607) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_inp_move5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5); 
/*********************** Features: five-axis linear interpolation ******************* ***** 
Features: 
Five-axis linear interpolation movement 
Parameters: 
 cardno card number 
axis1, axis2.axis3, axis4, axis5 number in the axis interpolation 
pulse1, pulse2, pulse3, pulse4, pulse5 move relative distance range (-8388608 ~ +8388607) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_inp_move6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6); 
/*********************** Features: Six-axis linear interpolation ******************* ***** 
Features: 
Six-axis linear interpolation motion 
Parameters: 
cardno card number 
pulse1, pulse2, pulse3, pulse4, pulse5, pulse6 
 The relative distance moved (-8388608 ~ +8388607) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

float _stdcall adt8960_get_hardware_ver (int cardno); 
/*************************** Get hardware version ******************* ******** 
Features: 
Get hardware version 
Parameters: 
cardno card number 
Return Value 1.0: Hardware 1.1 Hardware Second Edition First Edition 
************************************************** ****************/ 

int _stdcall adt8960_read_bit (int cardno, int number); 
/************************** Input read ****************** ********** 
Function: Read input 
Parameters: 
cardno card number 
Enter the point number (0-31) 
Return Value 0: Low 1: High -1: Error 
************************************************** *****************/ 

int _stdcall adt8960_write_bit (int cardno, int number, int value); 
/*************************** Read ***************** Output ************ 
Features: 
Read Output 
Parameters: 
cardno card number 
Output point number (0-15) 
value 0: Low 1: High 
Return Value 0: Correct 1: Error 
************************************************** ******************/ 

int _stdcall adt8960_set_suddenstop_mode (int cardno, int v, int logic); 
/**************************** Hardware stop mode ****************** ******** 
Features: 
Hardware stop mode 
Parameters: 
cardno card number 
v 0: Invalid 1: Valid 
logic 0: active low 1: active high 
Return Value 0: Correct 1: Error 
Stop signal of fixed hardware J2 terminal board with 33 pins (IN31) 
************************************************** ****************/ 

int _stdcall adt8960_set_io_mode (int cardno, int v1, int v2); 
/*************************** Set the input and output ****************** ************ 
Features: 
Set input and output 
 Parameters: 
v1 0: 8 points in front of the input is defined as 1: 8 points in front of the output is defined as 

v2 0: 8 points behind the input is defined as 1: 8 points behind is defined as the output 

  Return Value 0: Correct 1: Error 

 Note: When the IO point when used as outputs and can also read the input status 
************************************************** *******************/ 

int _stdcall adt8960_get_delay_status (int cardno); 
/************************** For delay status ******************* *********** 
Features: 
Access delay state 
Parameters: 
cardno card number 
Return Value 0: Delay the end of 1: Delay in progress 
************************************************** ******************/ 

int _stdcall adt8960_set_delay_time (int cardno, long time); 
/*************************** Set the delay time ***************** ************* 
Features: 
Set the delay time 
Parameters: 
cardno card number 
time delay 
Return Value 0: Correct 1: Error 
Time units 1/8us 
************************************************** *******************/ 

//*********************************************// 
// Composite driver class // 
//*********************************************// 
int _stdcall adt8960_symmetry_relative_move (int cardno, int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ******* 
* Function: the relative motion axis linear interpolation with reference to the current position, move to accelerate the quantitative 
* Parameters: 
      cardno-card 
axis --- Axis No. 
pulse - pulse 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** *******/ 

int _stdcall adt8960_symmetry_absolute_move (int cardno, int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ******** 
* Function: absolute motion axis linear interpolation with reference to the zero position, in order to speed up the quantitative movement 
* Parameters: 
      cardno-card 
axis --- Axis No. 
pulse - pulse 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ********/ 

int _stdcall adt8960_symmetry_relative_line2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ********* 
* Features: two-axis linear interpolation relative motion, with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** *********/ 

int _stdcall adt8960_symmetry_absolute_line2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ********** 
* Features: two-axis linear interpolation absolute motion, with reference to the zero position, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** **********/ 

int _stdcall adt8960_symmetry_relative_line3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* *********** 
* Features: three-axis linear interpolation relative motion, with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** *************/ 

int _stdcall adt8960_symmetry_absolute_line3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ************* 
Function: three-axis linear interpolation absolute motion, zero reference position to accelerate linear interpolation 
Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** **************/ 

int _stdcall adt8960_symmetry_relative_line4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* *************** 
* Features: Four-axis linear interpolation relative motion, with reference to the current location to expedite the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** **************/ 

int _stdcall adt8960_symmetry_absolute_line4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ************** 
* Function: absolute motion axis linear interpolation with reference to the zero position, acceleration and deceleration in a straight line interpolation to 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** **************/ 

int _stdcall adt8960_symmetry_relative_line5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Axis linear interpolation relative motion **************** 
* Function: with reference to the current location to acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 

int _stdcall adt8960_symmetry_absolute_line5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Symmetry axis linear interpolation absolute motion **************** 
* Function: with reference to the zero position, acceleration and deceleration for the symmetric linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 

int _stdcall adt8960_symmetry_relative_line6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Six-axis linear interpolation relative motion **************** 
* Function: with reference to the current location to acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 

int _stdcall adt8960_symmetry_absolute_line6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Six-axis absolute motion **************** symmetric linear interpolation 
* Function: with reference to the zero position, acceleration and deceleration for the symmetric linear interpolation 
* Parameters: 
      cardno-card 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 

//------------------------------------------------ ----// 
// 2008.10.6 // 
//------------------------------------------------ ----// 
int _stdcall adt8960_set_acac (int cardno, int axis, long value); 
/******************* Functions: acceleration / deceleration rate of change of setting ******************* * 
cardno card number 
No. axis axis 
value K value (1-65535) 
The actual rate of change 1000000 / k 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_set_ad_mode (int cardno, int axis, int mode); 
/********************* Functions: acceleration / deceleration mode setting ******************* *** 
cardno card number 
No. axis axis (1-4) 
mode 0: Linear acceleration / deceleration 1: S curve acceleration / deceleration 
Return Value 0: Correct 1: Error 
The default mode: linear acceleration / deceleration 
************************************************** ****************/ 

int _stdcall adt8960_get_ad (int cardno, int axis, long * ad); 
/******************* Function: get the axis of the current acceleration ********************* 
cardno card number 
No. axis axis 
The current acceleration of the pointer ad 
Return Value 0: Correct 1: Error 
Data-driven acceleration of the unit and set the value of A as 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// External signal driver // 
//------------------------------------------------ ----// 
int _stdcall adt8960_manual_continue (int cardno, int axis); 
/******************* Function: a continuous external signal driver ********************* 
cardno card number 
No. axis axis 
Return Value 0: Correct 1: Error 
Note: (1) a continuous pulse, but the driver does not immediately need to wait until the external signal level changes 
(2) You can use an ordinary button, you can also take over the wheel 
************************************************** ****************/ 

int _stdcall adt8960_manual_pmove (int cardno, int axis, long pos); 
/******************* Function: an external signal quantitatively driven ********************* 
cardno card number 
No. axis axis 
Return Value 0: Correct 1: Error 
Note: (1) a quantitative pulse, but the driver does not immediately need to wait until the external signal level changes 
(2) You can use an ordinary button, you can also take over the wheel 
************************************************** ****************/ 

int _stdcall adt8960_manual_disable (int cardno, int axis); 
/*********************** Driven off the external signal that can ******************** *** 
Features: Close to enable the external signal drive 
Parameters: 
cardno card number 
axis axis number (1-6) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Position latch // 
//------------------------------------------------ ----// 
int _stdcall adt8960_set_lock_position (int cardno, int axis, int mode, int regi, int logical); 
/**************************** Position latch set functions **************** ****** 
Function: signaling functions set in place, locked position of all axes and the actual location of the logic 
Parameters: 
axis-reference axis 
mode-latch mode | 0: Invalid 
| 1: Effective 
regi-Counter Mode | 0: logical location 
| 1: actual position 
logical-level signal | 0: rising edge 
| 1: falling 
Return Value 0: Correct 1: Error 
Note: Use the specified axis axis of the IN signal as the trigger signal 
************************************************** *****************/ 

int _stdcall adt8960_get_lock_status (int cardno, int axis, int * v); 
/************************* Get latched state ******************** *** 
Function: Get the status latch operations 
Parameters: 
cardno card number 
axis axis number (1-6) 
v 0 | not perform latch operation 
1 | latch operation performed 
Return Value 0: Correct 1: Error 
Description: Use this function to capture the position of whether to implement latch 
************************************************** ****************/ 

int _stdcall adt8960_get_lock_position (int cardno, int axis, long * pos); 
/************************** Get locked position ******************* ******* 
Features: access to the locked position 
Parameters: 
cardno card number 
axis axis number (1-6) 
latched position pos 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_clr_lock_status (int cardno, int axis); 
/************************** Clear lock ********************* ***** 
Function: Clear Lock 
Parameters: 
cardno card number 
axis axis number (1-6) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Hardware cache // 
//------------------------------------------------ ----// 
int _stdcall adt8960_fifo_inp_move1 (int cardno, int axis1, long pulse1, long speed); 
/************************** Uniaxial cache ******************** ****** 
Function: Single Cache 
Parameters: 
cardno card number 
axis1 axis number (1-6) 
pulse1 cache pulse 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space, each instruction cache takes three axis space, instruction cache 682 
************************************************** ****************/ 

int _stdcall adt8960_fifo_inp_move2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long speed); 
/************************** Two axes cache ******************** ****** 
Features: Two-axis cache 
Parameters: 
cardno card number 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
pulse1 pulses cache 
pulse2 pulses cache 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space, and each instruction takes two 4-axis cache space, instruction cache 512 
************************************************** ****************/ 

int _stdcall adt8960_fifo_inp_move3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long speed); 
/************************** Axis cache ******************** ****** 
Features: Triaxial cache 
Parameters: 
cardno card number 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
axis3 axis number (1-6) 
pulse1 pulses cache 
pulse2 pulses cache 
pulse3 pulses cache 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space, each instruction takes 5 axis cache space, instruction cache 409 
************************************************** ****************/ 

int _stdcall adt8960_fifo_inp_move4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long speed); 
/************************** Axis cache ******************** ****** 
Features: Four-axis cache 
Parameters: 
cardno card number 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
axis3 axis number (1-6) 
axis4 axis number (1-6) 
pulse1 pulses cache 
pulse2 pulses cache 
pulse3 pulses cache 
pulse4 pulses cache 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space, each axis takes 6 instruction cache space, instruction cache 341 
************************************************** ****************/ 

int _stdcall adt8960_fifo_inp_move5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long speed); 
/************************** Axis cache ******************** ****** 
Features: Five-axis cache 
Parameters: 
cardno card number 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
axis3 axis number (1-6) 
axis4 axis number (1-6) 
axis5 axis number (1-6) 
pulse1 pulses cache 
pulse2 pulses cache 
pulse3 pulses cache 
pulse4 pulses cache 
pulse5 pulses cache 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space occupied by each axis 7 instruction cache space, instruction cache 292 
************************************************** ****************/ 

int _stdcall adt8960_fifo_inp_move6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long speed); 
/************************** Six-axis cache ******************** ****** 
Features: Six-axis cache 
Parameters: 
cardno card number 
pulse1 pulses cache 
pulse2 pulses cache 
pulse3 pulses cache 
pulse4 pulses cache 
pulse5 pulses cache 
pulse6 pulses cache 
speed cache speed 
Return Value 0: Correct 1: Error 
Description: A total of 2048 buffer space occupied by each six-axis cache instruction 8 space, instruction cache 256 
************************************************** ****************/ 

int _stdcall adt8960_reset_fifo (int cardno); 
/************************** Reset cache ******************** ****** 
Features: Clear Cache 
Parameters: 
cardno card number 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_read_fifo_count (int cardno, int * value); 
/************************** Number ******************* read caching *** 
Function: the number of read caching, storage of instructions into how many left without implementation 
Parameters: 
cardno card number 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_read_fifo_empty (int cardno); 
/************************** Read cache state ******************* *** 
Function: read cache is empty 
Parameters: 
cardno card number 
Return Value 0: non-empty 1: Empty 
************************************************** ****************/ 

int _stdcall adt8960_read_fifo_full (int cardno); 
/************************** Read cache state ******************* *** 
Function: read cache is full, full, the data will no longer exist 
Parameters: 
cardno card number 
Return Value 0: less than 1: full 
************************************************** ****************/ 

//************************************************ **************************// 
// ************* ************* Manual deceleration // 
// First need to set the manual deceleration mode // 
// When the manual deceleration mode is active, set the manual deceleration point pos1 // 
// Set point offset pos2 // 
// Set the speed of manual deceleration point (low speed) endspeed // 
// Manual deceleration movement: Movement to the deceleration point automatically slow down to endspeed pos1 run // 
// To speed endspeed search for the origin signal, origin of the signal the need for external signal trigger (stop0 low-level trigger) // 
// When the origin of the signal is triggered, the motion immediately after the origin offset pos2 Stop // 
//************************************************ **************************// 

int _stdcall adt8960_set_dec_mode (int cardno, int axis, int mode); 
/************************** Set manual deceleration mode ******************* ******* 
Function: set the manual deceleration mode 
Parameters: 
cardno card number 
axis axis number (1-6) 
Manual mode 1, the effective deceleration mode 0 is not valid 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_set_dec_pos1 (int cardno, int axis, long pos); 
/************************** Set the manual deceleration point ******************* ******* 
Features: Manual deceleration point setting 
Parameters: 
cardno card number 
axis axis number (1-6) 
pos deceleration point 
Return Value 0: Correct 1: Error 
Description: to the deceleration of the deceleration point automatically to the specified low-speed movement, looking for the origin of the trigger signal, 
If you do not find the trigger signal, has been movement will continue at this rate until the end of the exercise 
************************************************** ****************/ 

int _stdcall adt8960_set_dec_pos2 (int cardno, int axis, long pos); 
/************************** Gear manually specified offset ***************** ********* 
Function: the origin offset 
Parameters: 
cardno card number 
axis axis number (1-6) 
the remaining position pos 
Return Value 0: Correct 1: Error 
Description: Sports offset the need for external signal to the trigger, the trigger signal is low level stop0 
************************************************** ****************/ 

int _stdcall adt8960_clr_dec_status (int cardno, int axis); 
/************************** Cleared manually deceleration state ******************* ******* 
Function: Clear manual deceleration state 
Parameters: 
cardno card number 
axis axis number (1-6) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_get_dec_status (int cardno, int axis, int * sta); 
/************************** For manual deceleration state ******************* ******* 
Function: Get the manual deceleration state 
Parameters: 
cardno card number 
axis axis number (1-6) 
deceleration state sta 
0: Searching 
1: search completed 
2: The movement has stopped, deceleration point not found 
3: does not meet the actual migration 
4: The Search for the servo off during deceleration point 
5: deceleration point has been found, not in place to offset movement (which may be the trigger limit, etc.) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 

int _stdcall adt8960_set_end_speed (int cardno, int axis, long speed); 
/**************** Function: to set trailing speed ************** 
Function: Setting of manual deceleration point, the slow speed to find the origin of the signal 
Parameters: 
cardno card number 
axis axis number (1-6) 
speed range (1-2M) 
Return Value 0: Correct 1: Error 
Note: If the manual deceleration point pos1 not found after the trigger signal (slow signal origin), has been movement will continue at this rate 
************************************************/ 


# endif